%function Test_MPEG
%Prueba_MPEG
%
%   See also 
   
%   Author: Fabien A.P. Petitcolas
%           Computer Laboratory
%           University of Cambridge
%   $Id: Test_MPEG.m,v 1.3 1998-06-24 10:21:06+01 fapp2 Exp $

%   References:
%    [1] Information technology -- Coding of moving pictures and associated
%        audio for digital storage media at up to 1,5 Mbits/s -- Part3: audio.
%        British standard. BSI, London. October 1993. Implementation of ISO/IEC
%        11172-3:1993. BSI, London. First edition 1993-08-01.
%
%   Legal notice:
%    This computer program is based on ISO/IEC 11172-3:1993, Information
%    technology -- Coding of moving pictures and associated audio for digital
%    storage media at up to about 1,5 Mbit/s -- Part 3: Audio, with the
%    permission of ISO. Copies of this standards can be purchased from the
%    British Standards Institution, 389 Chiswick High Road, GB-London W4 4AL, 
%    Telephone:+ 44 181 996 90 00, Telefax:+ 44 181 996 74 00 or from ISO,
%    postal box 56, CH-1211 Geneva 20, Telephone +41 22 749 0111, Telefax
%    +4122 734 1079. Copyright remains with ISO.
%-------------------------------------------------------------------------------
Common;
close all
% Crea una demo de ejemplo

% ************************************************************************
%                       DATOS DE ENTRADA
% fs Frecuencia de muestreo
% Ts Periodo de muestreo
% Ns el número de muestras debe ser múltiplo de 384
% Nf es el número de muestras de la señal en el dominio de la frecuencia
fs = 44100;
Ts=1/fs;
Ns= 384;
Nf=512;
%
%f = [1500 1700 1800 2000 10000 10500 11300 12000 13000]; % Frecuencias senos
%a = [   1.4    2      1.4      .5       2         0.5   1.5      3        1]; % Amplitudes
f = [1500 1700 1800 2000 10000  11000 12000 13000]; % Frecuencias senos
a = [   1.8    2      1.8      .5       2     1.5      3        0.5]; % Amplitudes
%t = 0:1/fs:1;

% ****************+ MODIFICADO *********************************
t = [0:1/fs:(Ns-1)*Ts];          % Vector tiempo de 384 puntos
frec=[0:fs/Nf:fs-(fs/Nf)];    % Vector frecuencia de 512 puntos
% ************************************************************************



% ************************************************************************
%                      SEÑAL DE ENTRADA
% Crea una señal aleatoria con las componentes sinusoidales y la normaliza
x = 0.4*randn(size(t));
for i = 1:length(f),
   x = x + a(i) * sin(2 * pi * f(i) * t);
end
x = x / max(abs(x));
s='tamaño de x y vector frec'
size(x)
size(frec)
%pause
%[x fs] = wavread('svega');
% ************************************************************************

% ************************************************************************
%                       TABLAS DE UMBRALES
% Carga tablas
[TH, TH_old, Map, LTq] = Table_absolute_threshold(1, fs, 128);
% Umbral en silencio
CB = Table_critical_band_boundaries(1, fs);
C = Table_analysis_window;
figure(1)
clg
plot(TH(:,1),TH_old(:,1))
title('Frecuencia de cada subbanda')
xlabel('índice muestral')
ylabel('Frecuencia')
pause
figure(2)
clg
plot(LTq)
title('Umbral en silencio')
figure(3)
clg
plot([1:512],C)
title('Ventana de análsis utilizada en el análisis de subbanda')
xlabel('muestra')
ylabel('coeficiente')
pause
% ************************************************************************

% Procesa el vector de entrada x.
for OFFSET = 1:384:length(x);
   S = [];
   
   % **********************************************************************
   % Análisis de subbanda. La capa 1 utiliza 12 muestras por subanda y hay
   % 32 subbandas.
   % **********************************************************************
   
   % Analisis de filtrado por subbanda [1, pp. 67].
   for i = 0:11,
       s=['ventana ' num2str(i) ]
      S = [S; Analysis_subband_filter(x, OFFSET + 32 * i, C,i)];
      pause
   end
   s='tamaño de x y S'
   size(x)
   size(S)
   close all
   % Scalefactor calculation [1, pp. 70].
   scf = Scale_factors(S);
   figure(5)
   clg
   plot(scf)
   title('factores de escala')
   size(scf)
   pause
   % **********************************************************************
   
   
   % **********************************************************************
   %                    ANÁLISIS PSICOACÚSTICO
   % **********************************************************************

	% Compute the FFT for time frequency conversion [1, pp. 110].
    % Calcula la FFT para conversión tiempo frecuencia.
	X = FFT_Analysis(x, OFFSET);
    figure(6)
    clg
    plot(frec,X)
    axis([0 fs/2 0 100]);
    xlabel('frecuencia (Hz) 0-fm/2')
    ylabel('PSD')
    title('maximo en 96 dB')
    pause
   
   % Determine the sound pressure level in each  subband [1, pp. 110].
   % Determina el nivel de presión sonora en cada subbanda.
   Lsb = Sound_pressure_level(X, scf);
   clg
   axis
   figure(7)
   plot(Lsb)
   replot
   title('Nivel de presión sonora')
   xlabel('muestra')
   pause
   
   % Busca las componentes tonales (sinusoidales) y no tonales (como ruido)
   % de la señal   [1, pp. 111--113]   
   [Flags Tonal_list Non_tonal_list] = Find_tonal_components(X, TH, Map, CB);
   
   % Decima los enmascaradores: elimina todos los enmascaradores
   % irrelevantes [1, pp. 114]
   [Flags Tonal_list Non_tonal_list] = ...
      Decimation(X, Tonal_list, Non_tonal_list, Flags, TH, Map);
   
   % Calcula los umbrales de enmascaramiento individuales [1, pp. 113--114]
   [LTt, LTn] = ...
      Individual_masking_thresholds(X, Tonal_list, Non_tonal_list, TH, Map);
   
   % Compute the global masking threshold [1, pp. 114]
   LTg = Global_masking_threshold(LTq, LTt, LTn);
   
   LTt
   LTq
   LTg
   pause
   if (DRAW)
       %figure(14)

      disp('Global masking threshold');
      hold on;
      plot(TH(:, INDEX), LTg, 'b-@');
      %hold off;
      title('Masking components and masking thresholds.');
      end
   
   % Determine the minimum masking threshold in each subband [1, pp. 114]
   LTmin = Minimum_masking_threshold(LTg, Map);
   if (DRAW)
      plot(LTmin); title('Minimum masking threshold');
      xlabel('Subband number'); ylabel('dB'); pause;
   end
   
   % Compute the singal-to-maks ratio
   hold off
   SMRsb = Lsb - LTmin;
   figure(20)
   plot(SMRsb)
   m1=max(SMRsb);
   m2=min(SMRsb);
   axis([0 32 m2 m1])
   %replot
   title('Relacion senal-mascara')
   xlabel('muestra')
end