function S = Analysis_subband_filter(Input, n, C,ventana)
%   S = Analysis_subband_filter(Input, n, C,ventana)
%
%   Devuelve las muestras de las 32  subbandas S(i) definidas en [1, pp. 67,78]
%   n es el índice en la entrada donde están las 32 nuevas muestras
%   C es la ventana de análisis definida en [1, pp.68--69].
%
%   See also Analysis_window
   
%   Author: Fabien A.P. Petitcolas
%           Computer Laboratory
%           University of Cambridge
%   Copyright (c) 1998 by Fabien A.P. Petitcolas
%   $Id: Analysis_subband_filter.m,v 1.3 1998-07-07 14:39:54+01 fapp2 Exp $

%   References:
%    [1] Information technology -- Coding of moving pictures and associated
%        audio for digital storage media at up to 1,5 Mbits/s -- Part3: audio.
%        British standard. BSI, London. October 1993. Implementation of ISO/IEC
%        11172-3:1993. BSI, London. First edition 1993-08-01.
%
%   Legal notice:
%    This computer program is based on ISO/IEC 11172-3:1993, Information
%    technology -- Coding of moving pictures and associated audio for digital
%    storage media at up to about 1,5 Mbit/s -- Part 3: Audio, with the
%    permission of ISO. Copies of this standards can be purchased from the
%    British Standards Institution, 389 Chiswick High Road, GB-London W4 4AL, 
%    Telephone:+ 44 181 996 90 00, Telefax:+ 44 181 996 74 00 or from ISO,
%    postal box 56, CH-1211 Geneva 20, Telephone +41 22 749 0111, Telefax
%    +4122 734 1079. Copyright remains with ISO.
%-------------------------------------------------------------------------------
Common;
s='nmax = length(input)      n'
nmax = length(Input)
n
v=num2str(ventana);
% Check input parameters
if (n + 31 > nmax | n < 1)
   error('Índice de análisis no esperado.');
end

% Crea un vector de entrada de 512 elementos. La muestra más reciente está
% en la posición 512, mientras que las mas vieja está en la posición 1
% Rellena con ceros si la señal de entrada no existe.
%  ...........................................................
%         |         480 samples        |  32 samples   |
%         n-480                         n              n+31

figure(4)
clg
plot(Input,'b')
title('Señal de entrada')
xlabel('muestras')
ylabel('amplitud')
pause
hold
plot([n:n+31],Input(n:n+31),'r')

s='en rojo la  ventana seleccionada'
%text(50,0.9,' En rojo la ventana de datos seleccionada')
pause
X = Input(max(1, n - 480):n + 31);          % / 32768
size(X)
plot(X,'b')
title(['ventana ' v])
xlabel('muestras')
ylabel('amplitud')
pause
X = X(:);
X = [zeros(512 - length(X), 1); X];
size(X)
clg
plot(X,'b')
title(['ventana ' v '    rellena con ceros al principio hasta 512 puntos'])
xlabel('muestras')
ylabel('amplitud')
pause
% Window vector X by vector C. This produces the Z buffer.
Z = X .* C;
mz=max(abs(Z(:)))
size(Z)
pause
clg
figure(4)
plot(Z,'b')
title(['ventana de datos' v  '  multiplicada por ventana de analisis C'])
xlabel('muestras')
ylabel('amplitud')
axis([0 512 -mz mz])
pause
axis
% Cálculo paracial 1): 64 coeficientes Yi
Y = zeros(1, 64);
for i = 1 : 64,
   for j = 0 : 7,
      Y(i) = Y(i) + Z(i + 64 * j);
   end
end

% Calculo parcial 2): los coeficientes del banco de filtros
for i = 0 : 31,
   for k = 0 : 63,
      M(i + 1, k + 1) = cos((2 * i + 1) * (k - 16) * pi / 64);
   end
end

% Calcula las muestras de las  32 subbandas  Si
S = zeros(1, 32);
for i = 1 : 32,
   for k = 1 : 64,
      S(i) = S(i) + M(i, k) * Y(k);
   end
end
clg
figure(4)
plot(S,'b')
title(['muestras subbanda ventana' num2str(ventana)])
xlabel('muestras')
ylabel('amplitud')
pause
