function Lsb = Sound_pressure_level(X, scf)
%    Lsb = Sound_pressure_level(X, scf)
%
%   Lsb es el nivel de presión sonora para cada subbanda.
%   X es la densidad de potencia espectral normalizada
%   scf son los 32 factores de escala (uno por banda)
%   
%
%   See also  Scale_factors
   
%   Author: Fabien A.P. Petitcolas
%           Computer Laboratory
%           University of Cambridge
%   Copyright (c) 1998 by Fabien A.P. Petitcolas
%   $Id: Sound_pressure_level.m,v 1.2 1998-06-22 17:47:56+01 fapp2 Exp $

%   References:
%    [1] Information technology -- Coding of moving pictures and associated
%        audio for digital storage media at up to 1,5 Mbits/s -- Part3: audio.
%        British standard. BSI, London. October 1993. Implementation of ISO/IEC
%        11172-3:1993. BSI, London. First edition 1993-08-01.
%
%   Legal notice:
%    This computer program is based on ISO/IEC 11172-3:1993, Information
%    technology -- Coding of moving pictures and associated audio for digital
%    storage media at up to about 1,5 Mbit/s -- Part 3: Audio, with the
%    permission of ISO. Copies of this standards can be purchased from the
%    British Standards Institution, 389 Chiswick High Road, GB-London W4 4AL, 
%    Telephone:+ 44 181 996 90 00, Telefax:+ 44 181 996 74 00 or from ISO,
%    postal box 56, CH-1211 Geneva 20, Telephone +41 22 749 0111, Telefax
%    +4122 734 1079. Copyright remains with ISO.
%-------------------------------------------------------------------------------
Common;

% Check input parameters
if (length(X) ~= FFT_SIZE)
   error('Unexpected power density spectrum size.');
end

if (length(scf) ~= N_SUBBAND)
   error('Unexpected number of scalefactors');
end

% *************************************************************************
% Toma los 32 niveles de presión sonora de las líneas espectrales con
% amplitud máxima en el rango de frecuencias correspondientes a la subbanda
% i y calcula el nivel de presión sonora Lsb.
Xmin = min(X);                         % Valor mínimo de la PSD normalizada
n = FFT_SIZE / 2 / N_SUBBAND; % Tamaño de cada subbanda

for i = 1:N_SUBBAND,                % PARA CADA SUBBANDA
   local_max = Xmin;
   for j = 1:n,                            % PARA CADA UNA DE LAS 32 MUESTRAS
      local_max = max(X((i - 1) * n + j), local_max);
   end
   Lsb(i) = max(local_max, 20 * log10(scf(i) * 32768) - 10);
end
% *************************************************************************
